const modeSelect = document.getElementById("mode");
const onceSettings = document.getElementById("once-settings");
const repeatSettings = document.getElementById("repeat-settings");
const calendarSettings = document.getElementById("calendar-settings");
const profileInput = document.getElementById("profileName");
const status = document.getElementById("status");

modeSelect.addEventListener("change", () => {
  onceSettings.style.display = modeSelect.value === "once" ? "block" : "none";
  repeatSettings.style.display = modeSelect.value === "repeat" ? "block" : "none";
  calendarSettings.style.display = modeSelect.value === "calendar" ? "block" : "none";
});

document.getElementById("startBtn").addEventListener("click", () => {
  const profileName = profileInput.value.trim() || "ללא שם";
  const mode = modeSelect.value;

  chrome.alarms.clearAll();

  if (mode === "once") {
    const minutes = parseInt(document.getElementById("onceDelay").value);
    chrome.alarms.create("autoRun", { delayInMinutes: minutes });
    status.textContent = `✅ הפעלה פעם אחת (${profileName}) בעוד ${minutes} דקות`;
  } 
  else if (mode === "repeat") {
    const interval = parseInt(document.getElementById("repeatDelay").value);
    chrome.alarms.create("autoRun", { periodInMinutes: interval });
    status.textContent = `🔁 הפעלה חוזרת (${profileName}) כל ${interval} דקות`;
  } 
  else if (mode === "calendar") {
    const timeValue = document.getElementById("calendarTime").value;
    const targetTime = new Date(timeValue).getTime();
    const now = Date.now();
    const delayMinutes = (targetTime - now) / 60000;
    if (delayMinutes > 0)
      chrome.alarms.create("autoRun", { delayInMinutes: delayMinutes });
    status.textContent = `📅 הפעלה לפי תאריך (${profileName}) ב-${timeValue}`;
  }
});

document.getElementById("stopBtn").addEventListener("click", () => {
  chrome.alarms.clearAll(() => status.textContent = "🛑 כל ההפעלות נעצרו");
});
